
#ifndef CRYS_HOST_TST_RSA
#define CRYS_HOST_TST_RSA

/***************************************************************** 
*  @file CRYS_HOST_TST_RSA.h
*  @brief Functions used for HOST-SEP communication to send message from HOST to SEP
*         that contains requested API to be executed in SEP and API parameters
*         Used for SEP External application ATP testing.
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "ExtApp_CRYS_Defines.h"
#include "CRYS.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/



/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RND_No_Reset         
* 
* Inputs:
* RNDSize - size of random vector to generate
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes RND no reset test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C CRYSError_t SEPQA_RND_No_Reset(DxUint16_t	RNDSize,
							            DxUint8_t   *FailureFunctionNameOut_ptr,
							            DxUint32_t   FuncNameMaxSize);
        						    
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RND_Reset         
* 
* Inputs:
* RNDSize - size of random vector to generate
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes RND with reset test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C CRYSError_t SEPQA_RND_Reset(DxUint16_t	  RNDSize,
							         DxUint8_t   *FailureFunctionNameOut_ptr,
							         DxUint32_t   FuncNameMaxSize);
									   
							             						    
        								  									  

#ifdef __cplusplus
}
#endif

#endif  /* CRYS_HOST_TST_RND */
